#include "c4d_painter.h"
#include "c4d_basecontainer.h"



TempUVHandle::TempUVHandle()
{
}

TempUVHandle::~TempUVHandle()
{
}

LONG TempUVHandle::GetMode()
{
	return C4DOS.Pa->UVSetGetMode(this);
}

Vector* TempUVHandle::GetPoint()
{
	return C4DOS.Pa->UVSetGetPoint(this);
}

LONG TempUVHandle::GetPointCount()
{
	return C4DOS.Pa->UVSetGetPointCount(this);
}

Polygon* TempUVHandle::GetPoly()
{
	return C4DOS.Pa->UVSetGetPoly(this);
}

LONG TempUVHandle::GetPolyCount()
{
	return C4DOS.Pa->UVSetGetPolyCount(this);
}

UVWStruct* TempUVHandle::GetUVW()
{
	return C4DOS.Pa->UVSetGetUVW(this);
}

BaseSelect* TempUVHandle::GetPolySel()
{
	return C4DOS.Pa->UVSetGetPolySel(this);
}

BaseSelect* TempUVHandle::GetUVPointSel()
{
	return C4DOS.Pa->UVSetGetPointSel(this);
}

Bool TempUVHandle::IsEditable()
{
	return C4DOS.Pa->UVSetIsEditable(this);
}

BaseObject* TempUVHandle::GetBaseObject()
{
	return C4DOS.Pa->UVSetGetBaseObject(this);
}

Bool TempUVHandle::SetUVW(UVWStruct* uvw)
{
	return C4DOS.Pa->UVSetSetUVW(this,uvw);
}


LONG IdentifyImage(const Filename &texpath)
{
	return C4DOS.Pa->IdentifyImage(texpath);
}

void *SendPainterCommand(LONG command, BaseDocument *doc, PaintTexture *tex, BaseContainer *bc)
{
	return C4DOS.Pa->SendPainterCommand(command,doc,tex,bc);
}

TempUVHandle *GetActiveUVSet(BaseDocument* doc, LONG flags)
{
	return C4DOS.Pa->GetActiveUVSet(doc,flags);
}

void FreeActiveUVSet(TempUVHandle *handle)
{
	C4DOS.Pa->FreeActiveUVSet(handle);
}

Bool CallUVCommand(Vector *padr, LONG PointCount, Polygon *polys, LONG lPolyCount, UVWStruct *uvw, BaseSelect *polyselection,
                   BaseSelect* pointselection, BaseObject*op, LONG mode, LONG cmdid, const BaseContainer &settings)
{
	return C4DOS.Pa->CallUVCommand(padr,PointCount,polys,lPolyCount,uvw,polyselection,pointselection,op,mode,cmdid,settings);
}

PaintTexture *CreateNewTexture(const Filename &path, const BaseContainer &settings)
{
	return C4DOS.Pa->CreateNewTexture(path,settings);
}

Bool GetTextureDefaults(LONG channel,BaseContainer &settings)
{
	return C4DOS.Pa->GetTextureDefaults(channel,settings);
}
